/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;

@Environment(value=EnvType.CLIENT)
public class IPOuterClientMisc {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static OuterConfig outerConfig = new OuterConfig();

    private static OuterConfig readFromFile() {
        File storageFile = IPOuterClientMisc.getStorageFile();
        if (storageFile.exists()) {
            OuterConfig result = null;
            try (FileReader fileReader = new FileReader(storageFile);){
                result = (OuterConfig)IPGlobal.gson.fromJson((Reader)fileReader, OuterConfig.class);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new OuterConfig();
            }
            if (result == null) {
                return new OuterConfig();
            }
            return result;
        }
        return new OuterConfig();
    }

    private static File getStorageFile() {
        return new File(class_310.method_1551().field_1697, "imm_ptl_state.json");
    }

    private static void writeToFile(OuterConfig outerConfig) {
        try (FileWriter fileWriter = new FileWriter(IPOuterClientMisc.getStorageFile());){
            IPGlobal.gson.toJson((Object)outerConfig, (Appendable)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initClient() {
        outerConfig = IPOuterClientMisc.readFromFile();
        DimStackInfo dimStackPreset = IPOuterClientMisc.outerConfig.dimensionStackDefault;
        if (dimStackPreset != null) {
            try {
                IPConfig config = IPConfig.getConfig();
                config.dimStackPreset = (JsonObject)IPGlobal.gson.toJsonTree((Object)dimStackPreset);
                config.saveConfigFile();
                IPOuterClientMisc.outerConfig.dimensionStackDefault = null;
                IPOuterClientMisc.writeToFile(outerConfig);
                LOGGER.info("Successfully upgraded dimension stack preset");
            }
            catch (Exception e) {
                LOGGER.info("Failed to upgrade dimension stack preset", (Throwable)e);
            }
        }
        Portal.CLIENT_PORTAL_SPAWN_EVENT.register(p -> {
            class_746 player = class_310.method_1551().field_1724;
            if (!IPOuterClientMisc.outerConfig.wikiInformed && player != null && player.method_7337()) {
                IPOuterClientMisc.outerConfig.wikiInformed = true;
                IPOuterClientMisc.writeToFile(outerConfig);
                IPOuterClientMisc.informWithURL("https://qouteall.fun/immptl/wiki/Portal-Customization", class_2561.method_43471((String)"imm_ptl.inform_wiki"));
            }
        });
    }

    private static void informWithURL(String link, class_5250 text) {
        CHelper.printChat((class_2561)text.method_10852((class_2561)McHelper.getLinkText(link)));
    }

    public static class OuterConfig {
        public boolean wikiInformed = false;
        public boolean portalHelperInformed = false;
        public boolean lagInformed = false;
        @Nullable
        public DimStackInfo dimensionStackDefault = null;
    }
}

